close all
clear all
path(pathdef); % resets path to default path

addpath ./functions/

load ../../'Estimation Results'/Benchmark_Model.mat

cd ./dynare_codes/

Model_Moments(parameters, N_variables, N_ll); % get benchmark statistics
evalc('dynare World_Economy_Cartel_VD.mod');

p_bench           = exp(oo_.steady_state(1));
y_bench           = exp(oo_.steady_state(16));
vol_dy            = (oo_.var(4,4))^(0.5);
vol_dp            = (oo_.var(1,1))^(0.5);
vol_dq            = (oo_.var(3,3))^(0.5);
MS_o              = (exp(oo_.steady_state(4)))/(exp(oo_.steady_state(15)));

exo_param.beta    = beta;
exo_param.epsilon = epsilon;
exo_param.alpha   = alpha;
exo_param.eta     = eta;
exo_param.psi     = psi;
exo_param.lambda  = lambda;
exo_param.nu      = nu;
exo_param.delta   = delta;
exo_param.gamma   = gamma;
exo_param.G_n     = G_n;
exo_param.G_o     = G_o;
exo_param.s_o     = s_o;
exo_param.varphi  = varphi;
exo_param.xi      = xi;

% Getting Fracking parameters

exo_param.eta_f   = 2.23;
exo_param.lambda_f= 1;
MS_f              = 0.2030704;

evalc('th_n_ss = fsolve( @(tt) calibrate_ss_resid_fracking(tt, exo_param, MS_f), 0.03);');
[resid, struct_param, endo_ss, phis] = calibrate_ss_resid_fracking(th_n_ss, exo_param, MS_f);

save calibration_parameters struct_param shock_param endo_ss

evalc('dynare World_Economy_Cartel_Fracking_VD.mod');

cd ../

save ./mat_files/fracking_long_run struct_param shock_param endo_ss phis

disp(' ')
disp('Table 11: Implications of fracking for key aggregate moments')
disp(' ')
disp('Moment             No fracking           Fracking')
disp('-------------------------------------------------')
disp(['Average p:                                 '  num2str(100*(exp(oo_.steady_state(1))/p_bench-1), '%.0f') '%'])
disp(['Average y:                                  +'  num2str(100*(exp(oo_.steady_state(16))/y_bench-1), '%.0f') '%'])
disp('-------------------------------------------------')
disp(['Volatility of dp:     '  num2str(vol_dp,'%.2f') '                 ' num2str(sqrt(oo_.var(1,1)), '%.2f')])
disp(['Volatility of dy:     '  num2str(vol_dy,'%.3f') '                ' num2str(sqrt(oo_.var(4,4)), '%.3f')])
disp('-------------------------------------------------')
disp(['OPEC''s market share:  '  num2str(MS_o*100,'%.1f') '%                ' num2str(100*(exp(oo_.steady_state(4)))/(exp(oo_.steady_state(15))), '%.1f') '%'])


MS_o_fracking             = (exp(oo_.steady_state(4)))/(exp(oo_.steady_state(15)));
MS_n_fracking             = (exp(oo_.steady_state(5)))/(exp(oo_.steady_state(15)));

disp(' ')
disp(' ')
disp(['Price volatility changes by      ' num2str(100*(sqrt(oo_.var(1,1))/vol_dp-1), '%.0f') '%'])
disp(['World GDP volatility changes by  ' num2str(100*(sqrt(oo_.var(4,4))/vol_dy-1), '%.1f') '%'])
disp(['Oil output volatility changes by ' num2str(100*(sqrt(oo_.var(3,3))/vol_dq-1), '%.0f') '%'])
disp(['OPEC market share drops from ' num2str(100*MS_o, '%.0f') '% to ' num2str(100*MS_o_fracking, '%.0f') '%'])
disp(['Conventional non-OPEC market share drops from ' num2str(100*(1-MS_o), '%.0f') '% to ' num2str(100*MS_n_fracking, '%.0f') '%'])